ORCA/M Asm65816 2.1.0

0001 4FB2                       TITLE 'Write prep routine'
0002 4FB2
0003 4FB2              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 4FB2              ;	by EdAsmCvtIIGS version 1.2d8 on 5/16/91 at 9:23:56 PM
0005 4FB2
0006 4FB2              *********************************************************
0007 4FB2              *
0008 4FB2              * 
0009 4FB2              * Writerprep: This routine will the users data, split it into three
0010 4FB2              *             segments and generate the checksum.  Once the data has
0011 4FB2              *             been split the fourth byte of the checksum is generated,
0012 4FB2              *             then the first three data bytes are nibblized.  The 
0013 4FB2              *             nibblizing of the data bytes creates a fourth byte which
0014 4FB2              *             contains the upper two bits from each of the data bytes.
0015 4FB2              *             This fourth byte will be kept in the upper half to the
0016 4FB2              *             accumulator.
0017 4FB2              *
0018 4FB2              *     Import: [cmdbuffl] = pointer to users data buffer
0019 4FB2              *             Y = number of groups of three bytes to move.
0020 4FB2              *                 The Y register is set up in the routine for the
0021 4FB2              *                 protocol converter write call routine.
0022 4FB2              *                 Y = 171 for Apple //e blocks
0023 4FB2              *                 Y = 175 for Macintosh blocks
0024 4FB2              *
0025 4FB2              *     Export: Cbyte0 = 1st nibblized data byte
0026 4FB2              *             Cbyte1 = 2nd nibblized data byte
0027 4FB2              *             Cbyte2 = 3rd nibblized data byte
0028 4FB2              *            B accum = extra bits from first three data bytes.
0029 4FB2              *
0030 4FB2              *********************************************************
0031 4FB2              WRITEPREP EQU   *                       ;
0032 4FB2                       LONGI ON                       	;
0033 4FB2 C2 10                 REP   #$10                     ;
0034 4FB4 64 52                 STZ   csuma
0035 4FB6 64 51                 STZ   csumb
0036 4FB8 64 50                 STZ   csumc
0037 4FBA 80 0E                 BRA   wp4
0038 4FBC              *
0039 4FBC              WPTOP    EQU   *
0040 4FBC B7 42                 LDA   [cmdbuffl],y
0041 4FBE 65 50                 ADC   csumc
0042 4FC0 85 50                 STA   csumc
0043 4FC2 B7 42                 LDA   [cmdbuffl],y
0044 4FC4 45 51                 EOR   csumb
0045 4FC6 9D 01 0E              STA   buf3+1,x
0046 4FC9 C8                    INY   
0047 4FCA              *
0048 4FCA              WP4      EQU   *
0049 4FCA 06 50                 ASL   csumc
0050 4FCC 90 02                 BCC   wp1
0051 4FCE E6 50                 INC   csumc
0052 4FD0              WP1      EQU   *
0053 4FD0 B7 42                 LDA   [cmdbuffl],y
0054 4FD2 65 52                 ADC   csuma
0055 4FD4 85 52                 STA   csuma
0056 4FD6 B7 42                 LDA   [cmdbuffl],y
0057 4FD8 45 50                 EOR   csumc
0058 4FDA 9D 00 0C              STA   buf1,x
0059 4FDD C8                    INY   
0060 4FDE              *
0061 4FDE              WP2      EQU   *
0062 4FDE B7 42                 LDA   [cmdbuffl],y
0063 4FE0 65 51                 ADC   csumb
0064 4FE2 85 51                 STA   csumb
0065 4FE4 B7 42                 LDA   [cmdbuffl],y
0066 4FE6 45 52                 EOR   csuma
0067 4FE8 9D 00 0D              STA   buf2,x
0068 4FEB C8                    INY   
0069 4FEC              *
0070 4FEC              WP3      EQU   *
0071 4FEC CA                    DEX   
0072 4FED D0 CD                 BNE   wptop
0073 4FEF                       LONGI OFF                      	;
0074 4FEF E2 10                 SEP   #$10                     ;
0075 4FF1              *
0076 4FF1              * And also figure the 'fourth' checksum byte
0077 4FF1              *
0078 4FF1 A5 50                 LDA   csumc                    ;CCCCCCCC
0079 4FF3 4A                    LSR   a                        ;0CCCCCCC
0080 4FF4 4A                    LSR   a                        ;00CCCCCC
0081 4FF5 45 51                 EOR   csumb                    ;00CCCCCC+BBBBBBBB
0082 4FF7 29 3F                 AND   #%00111111
0083 4FF9 45 51                 EOR   csumb                    ;BBCCCCCC
0084 4FFB 4A                    LSR   a                        ;0BBCCCCC
0085 4FFC 4A                    LSR   a                        ;00BBCCCC
0086 4FFD 45 52                 EOR   csuma
0087 4FFF 29 3F                 AND   #%00111111
0088 5001 45 52                 EOR   csuma                    ;AABBCCCC
0089 5003 4A                    LSR   a                        ;0AABBCCC
0090 5004 4A                    LSR   a                        ;00AABBCC
0091 5005 85 53                 STA   wcsum
0092 5007              *
0093 5007              * Okay, now prime the write pump with the first three data Cbytes.
0094 5007              *
0095 5007 A9 00                 LDA   #$00                     ; clear upper half of accumulator
0096 5009 EB                    XBA                            ;
0097 500A AD AF 0C              LDA   buf1+175
0098 500D 85 55                 STA   Cbyte1
0099 500F C2 20                 REP   #$20                     ; 16 bit accmulator
0100 5011 0A                    ASL   A                        ;
0101 5012 0A                    ASL   A                        ;
0102 5013 E2 20                 SEP   #$20                     ; 8 bit accumulator
0103 5015              *
0104 5015 AD AF 0D              LDA   buf2+175
0105 5018 85 56                 STA   Cbyte2
0106 501A C2 20                 REP   #$20                     ; 16 bit accmulator
0107 501C 0A                    ASL   A                        ;
0108 501D 0A                    ASL   A                        ;
0109 501E E2 20                 SEP   #$20                     ; 8 bit accumulator
0110 5020              *
0111 5020 AD AF 0E              LDA   buf3+175
0112 5023 85 57                 STA   Cbyte3
0113 5025 C2 20                 REP   #$20                     ; 16 bit accmulator
0114 5027 0A                    ASL   A                        ;
0115 5028 0A                    ASL   A                        ;
0116 5029 E2 20                 SEP   #$20                     ; 8 bit accumulator
0117 502B 60                    RTS   
0118 502C
0119 502C                       TITLE 'Write Routines'
0120 502C              **********************************************************************
0121 502C              *	General Write Data Field Routine
0122 502C              * 
0123 502C              *  Selects between MFM and GCR Write Routines
0124 502C              **********************************************************************
0125 502C              WRITEDATA EQU   *
0126 502C 5C 7F 0F E1  @GCR     JMP   WriteDataHook
0127 5030              *
0128 5030              * Okay, into write mode and write sync bytes
0129 5030              *
0130 5030 2C ED C0     WriteData~GCR BIT   l6set               ;Write prep
0131 5033 A9 FF                 LDA   #$FF                     ;First sync byte
0132 5035 8D EF C0              STA   l7set
0133 5038              *
0134 5038 A0 07                 LDY   #7
0135 503A B9 58 0F     WD00     LDA   datamarks,y
0136 503D 2C EC C0     WD0      BIT   l6clr                    ;Wait for buffer ready
0137 5040 10 FB                 BPL   wd0
0138 5042 8D ED C0              STA   l6set
0139 5045 88                    DEY   
0140 5046 10 F2                 BPL   wd00
0141 5048              *
0142 5048 AE 33 0F              LDX   sectfnd                  ;Send sector number
0143 504B BF 00 3D FF           LDA   >nibtab,x
0144 504F 09 80                 ORA   #$80
0145 5051 2C EC C0     SNDB1    BIT   l6clr
0146 5054 10 FB                 BPL   sndb1
0147 5056 8D ED C0              STA   l6set
0148 5059              *
0149 5059              * Okay, start sending the data.
0150 5059              *
0151 5059 A0 AE                 LDY   #174                     ;Write 174*3+2 nibbles
0152 505B 80 19                 BRA   wdb
0153 505D              *
0154 505D              WDC      EQU   *
0155 505D A6 57                 LDX   Cbyte3
0156 505F B9 01 0E              LDA   buf3+1,y
0157 5062 85 57                 STA   Cbyte3
0158 5064 C2 20                 REP   #$20                     ; 16 bit accmulator
0159 5066 0A                    ASL   A                        ;
0160 5067 0A                    ASL   A                        ;
0161 5068 E2 20                 SEP   #$20                     ; 8 bit accumulator
0162 506A BF 00 3D FF           LDA   >nibtab,x                ; kill time
0163 506E 2C EC C0     WDL      BIT   l6clr                    ; wait for IWM ready
0164 5071 10 FB                 BPL   wdl                      ;
0165 5073 8D ED C0              STA   l6set                    ;Output previous Cbyte 3
0166 5076              *
0167 5076              WDB      EQU   *
0168 5076 EB                    XBA                            ;
0169 5077 AA                    TAX                            ; get extra bits
0170 5078 BF 00 3D FF           LDA   >nibtab,x                ;Nibblize
0171 507C 2C EC C0     WDA      BIT   l6clr
0172 507F 10 FB                 BPL   wda
0173 5081 8D ED C0              STA   l6set
0174 5084              *
0175 5084 A6 55                 LDX   Cbyte1
0176 5086 B9 00 0C              LDA   buf1,y
0177 5089 85 55                 STA   Cbyte1
0178 508B C2 20                 REP   #$20                     ; 16 bit accmulator
0179 508D 0A                    ASL   A                        ;
0180 508E 0A                    ASL   A                        ;
0181 508F E2 20                 SEP   #$20                     ; 8 bit accumulator
0182 5091 BF 00 3D FF           LDA   >nibtab,x
0183 5095 2C EC C0     WDM      BIT   l6clr                    ; wait for IWM ready
0184 5098 10 FB                 BPL   wdm                      ;
0185 509A 8D ED C0              STA   l6set                    ;Send previous byte 1
0186 509D              *
0187 509D A6 56                 LDX   Cbyte2
0188 509F B9 00 0D              LDA   buf2,y
0189 50A2 85 56                 STA   Cbyte2
0190 50A4 C2 20                 REP   #$20                     ; 16 bit accmulator
0191 50A6 0A                    ASL   A                        ;
0192 50A7 0A                    ASL   A                        ;
0193 50A8 E2 20                 SEP   #$20                     ; 8 bit accumulator
0194 50AA BF 00 3D FF           LDA   >nibtab,x
0195 50AE 2C EC C0     WDK      BIT   l6clr                    ; wait for buffer empty
0196 50B1 10 FB                 BPL   wdk                      ;
0197 50B3 8D ED C0              STA   l6set
0198 50B6              *
0199 50B6 88                    DEY   
0200 50B7 C0 FF                 CPY   #$FF
0201 50B9 D0 A2                 BNE   wdc
0202 50BB              *
0203 50BB              * Now send the checksum as four encoded nibbles
0204 50BB              *
0205 50BB A0 03                 LDY   #3
0206 50BD              WDG      EQU   *
0207 50BD BB                    TYX                            ; form index
0208 50BE B5 50                 LDA   csumc,x
0209 50C0 29 3F                 AND   #$3F
0210 50C2 AA                    TAX   
0211 50C3 BF 00 3D FF           LDA   >nibtab,x
0212 50C7 2C EC C0     WDD      BIT   l6clr
0213 50CA 10 FB                 BPL   wdd
0214 50CC 8D ED C0              STA   l6set
0215 50CF 88                    DEY   
0216 50D0 10 EB                 BPL   wdg
0217 50D2              *
0218 50D2              * Now send the data bitslip marks
0219 50D2              *
0220 50D2 A0 02                 LDY   #2
0221 50D4 B9 61 0F     WDF      LDA   bsmarks,y
0222 50D7 2C EC C0     WDE      BIT   l6clr
0223 50DA 10 FB                 BPL   wde
0224 50DC 8D ED C0              STA   l6set
0225 50DF 88                    DEY   
0226 50E0 10 F2                 BPL   wdf
0227 50E2              *
0228 50E2              * Wait til write underrun
0229 50E2              *
0230 50E2 2C EC C0     WDH      BIT   l6clr
0231 50E5 70 FB                 BVS   wdh
0232 50E7 2C EE C0              BIT   l7clr                    ;Back into read mode
0233 50EA 60                    RTS   
0234 50EB
0235 50EB
0236 50EB                       eject 
0237 50EB
0238 50EB              **********************************************************************
0239 50EB              * Merge It combines the triple read buffer into 1 512 byte user buffer
0240 50EB              **********************************************************************
0241 50EB              MERGEIT  EQU   *
0242 50EB              *
0243 50EB              * Merge data from read into a contiguous block
0244 50EB              *
0245 50EB 08                    PHP                            ; save processor state
0246 50EC FB                    XCE                            ;
0247 50ED 08                    PHP                            ;
0248 50EE 18                    CLC                            ; native, m=1, x=0
0249 50EF FB                    XCE   
0250 50F0                       LONGA OFF                      	;
0251 50F0                       LONGI ON                       	;
0252 50F0 C2 10                 REP   #$10                     ;
0253 50F2 E2 20                 SEP   #$20                     ;
0254 50F4 A2 01 00              LDX   #0001
0255 50F7 A0 FF 01              LDY   #0511
0256 50FA 5A                    PHY   
0257 50FB AD 51 0F              LDA   mac_flag                 ; check for mac read or write
0258 50FE F0 28                 BEQ   @512                     ; if clear merge 512 bytes
0259 5100              ***********************************
0260 5100 7A                    PLY   
0261 5101 A0 0B 02              LDY   #523
0262 5104 5A                    PHY   
0263 5105 80 08                 BRA   @524
0264 5107              @10      EQU   *
0265 5107 BD 00 0E              LDA   buf3,x
0266 510A 97 42                 STA   [cmdbuffl],y
0267 510C 88                    DEY   
0268 510D 30 28                 BMI   @90                      ; are we done?
0269 510F              *
0270 510F BD 00 0D     @524     LDA   buf2,x
0271 5112 97 42                 STA   [cmdbuffl],y
0272 5114 88                    DEY                            ;
0273 5115 30 20                 BMI   @90
0274 5117              *
0275 5117 BD 00 0C              LDA   buf1,x
0276 511A 97 42                 STA   [cmdbuffl],y
0277 511C E8                    INX                            ; point to next src byte
0278 511D 88                    DEY                            ; bump dest index
0279 511E 10 E7                 BPL   @10                      ;
0280 5120 80 15                 BRA   @90
0281 5122              *****************************************
0282 5122              * This is coded for maximum performance 
0283 5122              * for the normal 512 byte case
0284 5122              *****************************************
0285 5122              @50      EQU   *
0286 5122 BD 00 0E              LDA   buf3,x
0287 5125 97 42                 STA   [cmdbuffl],y
0288 5127 88                    DEY   
0289 5128              *
0290 5128 BD 00 0D     @512     LDA   buf2,x
0291 512B 97 42                 STA   [cmdbuffl],y
0292 512D 88                    DEY                            ;
0293 512E              *
0294 512E BD 00 0C              LDA   buf1,x
0295 5131 97 42                 STA   [cmdbuffl],y
0296 5133 E8                    INX                            ; point to next src byte
0297 5134 88                    DEY                            ; bump dest index
0298 5135 10 EB                 BPL   @50                      ;
0299 5137              ************************************
0300 5137              @90      EQU   *
0301 5137 68                    PLA                            ; restore low byte of count
0302 5138 EB                    XBA                            ;
0303 5139 68                    PLA                            ; restore high byte of count
0304 513A 28                    PLP                            ; restore processor state
0305 513B FB                    XCE                            ;
0306 513C 28                    PLP                            ;
0307 513D                       LONGA OFF                      	;
0308 513D                       LONGI OFF                      	;
0309 513D A8                    TAY                            ; y = high byte of byte count
0310 513E EB                    XBA                            ;
0311 513F AA                    TAX                            ; x = low byte of byte count
0312 5140 60                    RTS   
0313 5141                       TITLE 'RawRead'
0314 5141              ***********************************************************
0315 5141              *
0316 5141              * RawRead 
0317 5141              *
0318 5141              *    INPUT : cmdbuffl   pointer to output buffer
0319 5141              *          : cmdcount   size of of output buffer
0320 5141              *          : cmdadrs    pointer to following ctrl list
0321 5141              *      
0322 5141              * ctrl list: list size in bytes
0323 5141              *          : track number (lsb is side bit)
0324 5141              *          : Sector number (0,1..n)
0325 5141              *          : Read count
0326 5141              *          : Search count
0327 5141              *          : Search pattern (0..16 bytes)
0328 5141              *
0329 5141              ***********************************************************
0330 5141              RAWREAD  EQU   *
0331 5141 2C 1E 0F              BIT   ext_flag
0332 5144 70 04                 BVS   @01
0333 5146 A9 01                 LDA   #cmderror
0334 5148 80 53                 BRA   @err
0335 514A              @01      EQU   *
0336 514A A7 4A                 LDA   [cmdadrs]                ;get list length
0337 514C F0 08                 BEQ   @bcerr
0338 514E C9 08                 CMP   #08
0339 5150 90 04                 BCC   @bcerr
0340 5152 C9 13                 CMP   #19
0341 5154 90 04                 BCC   @05                      ;max is 18
0342 5156 A9 22        @BCERR   LDA   #bcparmcnt
0343 5158 80 43                 BRA   @err
0344 515A A0 05        @05      LDY   #05
0345 515C B7 4A                 LDA   [cmdadrs],y
0346 515E 10 11                 BPL   @10
0347 5160 A0 02                 LDY   #02
0348 5162 B7 4A                 LDA   [cmdadrs],y
0349 5164 8D 2A 0F              STA   sector
0350 5167 A0 06                 LDY   #06
0351 5169 B7 4A                 LDA   [cmdadrs],y
0352 516B 8D 4E 0F              STA   trkcnt
0353 516E 82 25 01              BRL   H5296
0354 5171
0355 5171 18           @10      CLC   
0356 5172 20 05 4A              JSR   SensnChk                 ;enable, sense and chk
0357 5175 B0 26                 BCS   @err                     ;bailout if any err
0358 5177 A9 03                 LDA   #3
0359 5179 8D 37 0F              STA   readret                  ;set read retry maximum
0360 517C 20 47 49              JSR   MotorOn                  ;enable motor on drive
0361 517F A0 02                 LDY   #02
0362 5181 B7 4A                 LDA   [cmdadrs],y
0363 5183 4A                    LSR   a                        ;side bit to carry
0364 5184 9C 2B 0F              STZ   side
0365 5187 6E 2B 0F              ROR   side                     ;set side as $00/$80
0366 518A C9 50                 CMP   #80
0367 518C 90 02                 BCC   @24
0368 518E A9 4F                 LDA   #79
0369 5190              @24      EQU   *
0370 5190 8D 29 0F              STA   cyl
0371 5193 20 26 48              JSR   Seek                     ;this only gets 1 chance
0372 5196              *
0373 5196              *  wait for Ready from drive (but not forever)
0374 5196 20 25 49              JSR   WaitRdyTO
0375 5199 90 05                 BCC   @30
0376 519B A9 2F                 LDA   #offline
0377 519D 82 CF EA     @ERR     BRL   set_err
0378 51A0 20 C6 4C     @30      JSR   Rdmode                   ;select side and rdmode
0379 51A3              *
0380 51A3              * Now select which RawRead routine to call
0381 51A3 A0 04                 LDY   #04                      ;get offset to sector parm
0382 51A5 B7 4A                 LDA   [cmdadrs],y
0383 51A7 D0 0B                 BNE   @50                      ;sector non zero case
0384 51A9 A7 4A                 LDA   [cmdadrs]                ;get length
0385 51AB C9 0B                 CMP   #11
0386 51AD 90 A7                 BCC   @bcerr
0387 51AF 20 C2 51     @40      JSR   PatrnRawRd               ;call the pattern match case
0388 51B2 80 03                 BRA   @60
0389 51B4 20 1C 52     @50      JSR   SectRawRd                ;call the sector match case
0390 51B7 90 04        @60      BCC   @80
0391 51B9 A9 27                 LDA   #ioerror
0392 51BB 80 E0                 BRA   @err
0393 51BD 9C 4B 0F     @80      STZ   statbyte
0394 51C0 18                    CLC   
0395 51C1 60                    RTS   
0396 51C2              **************************************************
0397 51C2              *                                                *
0398 51C2              *             C <- clr:all okay, set:field error *
0399 51C2              *   Destroys: A, X, Y, temp                      *
0400 51C2              *   Assumes: caller did WaitRdyTO and Rdmode     *
0401 51C2              *                                                *
0402 51C2              **************************************************
0403 51C2              PATRNRAWRD EQU   *
0404 51C2 A0 08                 LDY   #08
0405 51C4 B7 4A                 LDA   [cmdadrs],y              ;get pattrn length
0406 51C6 AA                    TAX   
0407 51C7 18                    CLC   
0408 51C8 69 0B                 ADC   #11
0409 51CA 85 4F                 STA   csum
0410 51CC 8A                    TXA   
0411 51CD F0 02                 BEQ   @01
0412 51CF A9 80                 LDA   #$80
0413 51D1 85 50        @01      STA   csumc                    ;00= no pattern $80 = pattern to match
0414 51D3              *
0415 51D3              * Setup ReadCnt in a zpg temp
0416 51D3 A0 07                 LDY   #07
0417 51D5 B7 4A                 LDA   [cmdadrs],y
0418 51D7 85 52                 STA   csuma                    ;csuma immediately follows csumb !!
0419 51D9 88                    DEY   
0420 51DA B7 4A                 LDA   [cmdadrs],y
0421 51DC 85 51                 STA   csumb                    ;csumb immediately preceeds csmua !!
0422 51DE              *
0423 51DE              * Set up the timeout
0424 51DE              *
0425 51DE A9 07                 LDA   #>2000
0426 51E0 85 5A                 STA   temp
0427 51E2 A2 D0                 LDX   #<2000
0428 51E4 24 50                 BIT   csumc
0429 51E6 10 17                 BPL   @rawrd
0430 51E8 A0 0A        @RB      LDY   #10                      ;offset to 1st pattern byte
0431 51EA CA           @RC      DEX                            ;Maintain double byte t.o. ctr
0432 51EB D0 04                 BNE   @Ra                      ;=> no timeout
0433 51ED C6 5A                 DEC   temp
0434 51EF 30 24                 BMI   @Rerr                    ;Oops, timeout error
0435 51F1              * 
0436 51F1 AD EC C0     @RA      LDA   l6clr                    ;Look for a byte
0437 51F4 10 FB                 BPL   @Ra                      ;Branch if no byte ready
0438 51F6 D7 4A                 CMP   [cmdadrs],y              ;pattern match? 
0439 51F8 D0 EE                 BNE   @Rb                      ;No, start all over 
0440 51FA C8                    INY                            ;Yes, found a matching byte
0441 51FB C4 4F                 CPY   csum                     ;whole pattern matched?
0442 51FD 90 EB                 BCC   @Rc
0443 51FF              *
0444 51FF              * Now copy the next csumb (ReadCnt) nybbles to user buffer
0445 51FF C2 10        @RAWRD   REP   #$10
0446 5201                       LONGI ON
0447 5201 A6 51                 LDX   csumb                    ; 16 bit ldx
0448 5203 A0 00 00              LDY   #0000
0449 5206 AD EC C0     @40      LDA   l6clr
0450 5209 10 FB                 BPL   @40
0451 520B 97 42                 STA   [cmdbuffl],y
0452 520D C8                    INY   
0453 520E CA                    DEX   
0454 520F D0 F5                 BNE   @40
0455 5211 E2 10                 SEP   #$10
0456 5213                       LONGI OFF
0457 5213              *
0458 5213 18                    CLC                            ;Ok there's the stuff
0459 5214 60                    RTS   
0460 5215 A9 21        @RERR    LDA   #adrerror+$01            ;adrs + timeout bits
0461 5217 0C 44 0F              TSB   error2
0462 521A 38                    SEC   
0463 521B 60                    RTS   
0464 521C                       EJECT 
0465 521C              **************************************************
0466 521C              *                                                *
0467 521C              *             C <- clr:all okay, set:field error *
0468 521C              *   Destroys: A, X, Y, temp                      *
0469 521C              *   Assumes: caller did WaitRdyTO and Rdmode     *
0470 521C              *                                                *
0471 521C              **************************************************
0472 521C              SECTRAWRD EQU   *
0473 521C              *
0474 521C              * Setup ReadCnt-5 in a zpg temp
0475 521C A0 06                 LDY   #06
0476 521E C2 20                 REP   #$20
0477 5220                       LONGA ON
0478 5220 B7 4A                 LDA   [cmdadrs],y
0479 5222 38                    SEC   
0480 5223 E9 05 00              SBC   #0005
0481 5226 85 51                 STA   csumb                    ;csumb immediately preceeds csmua !!
0482 5228 E2 20                 SEP   #$20
0483 522A                       LONGA OFF
0484 522A 10 05                 BPL   @00
0485 522C A9 22                 LDA   #bcparmcnt
0486 522E 82 3E EA              BRL   set_err
0487 5231              *
0488 5231              * Set up the timeout
0489 5231              *
0490 5231 64 5B        @00      STZ   temp2                    ;zero the sector retry counter
0491 5233 A9 27        @R0      LDA   #>10000
0492 5235 85 5A                 STA   temp
0493 5237 A0 10                 LDY   #<10000
0494 5239 A2 02        @RB      LDX   #3-1                     ;
0495 523B 88           @RC      DEY                            ;Maintain double byte t.o. ctr
0496 523C D0 04                 BNE   @Ra                      ;=> no timeout
0497 523E C6 5A                 DEC   temp
0498 5240 30 2B                 BMI   @Rerr                    ;Oops, timeout error
0499 5242              * 
0500 5242 AD EC C0     @RA      LDA   l6clr                    ;Look for a byte
0501 5245 10 FB                 BPL   @Ra                      ;Branch if no byte ready
0502 5247 DD 69 0F              CMP   adrmarks,x               ;is it D5,AA,96?
0503 524A D0 ED                 BNE   @Rb                      ;No, start all over 
0504 524C              * I have now found an address mark
0505 524C A0 03        @RD      LDY   #03
0506 524E AD EC C0     @RE      LDA   l6clr
0507 5251 10 FB                 BPL   @Re
0508 5253 97 42                 STA   [cmdbuffl],y             ;save the cyl nybble
0509 5255 AE EC C0     @RF      LDX   l6clr                    ;read the sector nybble
0510 5258 10 FB                 BPL   @rf
0511 525A BF 00 3C FF           LDA   >dnibtab,x               ;get sector as data (0..63)
0512 525E C8                    INY                            ;y=04
0513 525F 1A                    INC   a                        ;convert sector to 1 based
0514 5260 D7 4A                 CMP   [cmdadrs],y              ;is this the requested sector?
0515 5262 F0 10                 BEQ   @30                      ;yes. so copy count bytes-3
0516 5264 E6 5B                 INC   temp2
0517 5266 A5 5B                 LDA   temp2
0518 5268 CD 36 0F              CMP   adrsret                  ;enough adrs mark retries?
0519 526B 90 C6                 BCC   @R0                      ;no. try again
0520 526D              *
0521 526D              * ERROR Exit: couldn't find the sector's adrs mark
0522 526D A9 20        @RERR    LDA   #adrerror
0523 526F 0C 44 0F              TSB   error2
0524 5272 38                    SEC   
0525 5273 60                    RTS   
0526 5274              *
0527 5274              * Now copy next ReadCnt nybbles to user buffer
0528 5274              @30      EQU   *
0529 5274 8A                    TXA   
0530 5275 97 42                 STA   [cmdbuffl],y             ;save the sector nybble
0531 5277 C2 10                 REP   #$10
0532 5279                       LONGI ON
0533 5279 A6 51                 LDX   csumb                    ;get read length (16 bits)
0534 527B AD EC C0     @40      LDA   l6clr
0535 527E 10 FB                 BPL   @40
0536 5280 C8                    INY   
0537 5281 97 42                 STA   [cmdbuffl],y
0538 5283 CA                    DEX   
0539 5284 D0 F5                 BNE   @40
0540 5286 E2 10                 SEP   #$10
0541 5288                       LONGI OFF
0542 5288              *
0543 5288              * Now reconstruct the 3 mark bytes in user's buffer
0544 5288 A2 02                 LDX   #3-1
0545 528A 9B                    TXY   
0546 528B BD 69 0F     @80      LDA   adrmarks,x
0547 528E 97 42                 STA   [cmdbuffl],y
0548 5290 88                    DEY   
0549 5291 CA                    DEX   
0550 5292 10 F7                 BPL   @80
0551 5294              *
0552 5294 18                    CLC                            ;Ok there's the stuff
0553 5295 60                    RTS   
0554 5296
0555 5296 18           H5296    CLC   
0556 5297 20 05 4A              JSR   sensnchk
0557 529A B0 07                 BCS   H52A3
0558 529C 10 09                 BPL   H52A7
0559 529E 20 68 47              JSR   mountvol
0560 52A1 90 04                 BCC   H52A7
0561 52A3 8D 4B 0F     H52A3    STA   statbyte
0562 52A6 60                    RTS   
0563 52A7 A5 43        H52A7    LDA   cmdbuffl+1
0564 52A9 85 5D                 STA   basesave
0565 52AB AD 2A 0F     H52AB    LDA   sector
0566 52AE C9 A0                 CMP   #160
0567 52B0 B0 4A                 BCS   H52FC
0568 52B2 9C 2B 0F              STZ   side
0569 52B5 4A                    LSR   A
0570 52B6 8D 29 0F              STA   cyl
0571 52B9 6E 2B 0F              ROR   side
0572 52BC AE 28 0F              LDX   drive
0573 52BF AD 29 0F              LDA   cyl
0574 52C2 20 10 4B              JSR   cylsect
0575 52C5 8D 2C 0F              STA   curnsect
0576 52C8 A8                    TAY   
0577 52C9 8D 37 0F              STA   readret
0578 52CC 0A                    ASL   A
0579 52CD 1A                    INC   A
0580 52CE 8D 36 0F              STA   adrsret
0581 52D1 A9 02                 LDA   #02
0582 52D3 8D 35 0F              STA   seekret
0583 52D6 A9 80                 LDA   #$80
0584 52D8 88           H52D8    DEY   
0585 52D9 99 00 0F              STA   xlvtab,y
0586 52DC D0 FA                 BNE   H52D8
0587 52DE A5 43                 LDA   cmdbuffl+1
0588 52E0 85 54                 STA   basepage
0589 52E2 20 47 49              JSR   motoron
0590 52E5 20 26 48     H52E5    JSR   seek
0591 52E8 90 20                 BCC   H530A
0592 52EA 80 0B                 BRA   H52F7
0593 52EC AE 28 0F     H52EC    LDX   drive
0594 52EF 9D 3A 0F              STA   curcyl,x
0595 52F2 A9 04                 LDA   #sftskerror
0596 52F4 0C 44 0F              TSB   error2
0597 52F7 CE 35 0F     H52F7    DEC   seekret
0598 52FA D0 E9                 BNE   H52E5
0599 52FC A9 27        H52FC    LDA   #ioerror
0600 52FE A6 5D        H52FE    LDX   basesave
0601 5300 86 43                 STX   cmdbuffl+1
0602 5302 82 6A E9              BRL   set_err
0603 5305 CE 36 0F     H5305    DEC   adrsret
0604 5308 F0 F2                 BEQ   H52FC
0605 530A 20 4F 4C     H530A    JSR   rdaddr
0606 530D 90 08                 BCC   H5317
0607 530F 24 5A                 BIT   temp
0608 5311 10 F2                 BPL   H5305
0609 5313 50 E9                 BVC   H52FE
0610 5315 80 E5                 BRA   H52FC
0611 5317 AD 32 0F     H5317    LDA   sidefnd
0612 531A 4A                    LSR   A
0613 531B AD 34 0F              LDA   trkfnd
0614 531E 90 02                 BCC   H5322
0615 5320 09 40                 ORA   #$40
0616 5322 CD 29 0F     H5322    CMP   cyl
0617 5325 D0 C5                 BNE   H52EC
0618 5327 A9 20                 LDA   #$20
0619 5329 2D 32 0F              AND   sidefnd
0620 532C 0A                    ASL   A
0621 532D 0A                    ASL   A
0622 532E 4D 2B 0F              EOR   side
0623 5331 30 D2                 BMI   H5305
0624 5333 AE 33 0F              LDX   sectfnd
0625 5336 BD 00 0F              LDA   xlvtab,x
0626 5339 F0 CA                 BEQ   H5305
0627 533B 8A                    TXA   
0628 533C 0A                    ASL   A
0629 533D 65 54                 ADC   basepage
0630 533F 85 43                 STA   cmdbuffl+1
0631 5341 A9 FF                 LDA   #$FF
0632 5343 8D 42 0F              STA   drswtch
0633 5346 20 D9 4C              JSR   readdata
0634 5349 B0 BA                 BCS   H5305
0635 534B AE 33 0F              LDX   sectfnd
0636 534E 9E 00 0F              STZ   xlvtab,x
0637 5351 CE 37 0F              DEC   readret
0638 5354 D0 AF                 BNE   H5305
0639 5356 CE 4E 0F              DEC   trkcnt
0640 5359 F0 15                 BEQ   H5370
0641 535B EE 2A 0F              INC   sector
0642 535E AD 2C 0F              LDA   curnsect
0643 5361 0A                    ASL   A
0644 5362 18                    CLC   
0645 5363 65 54                 ADC   basepage
0646 5365 85 43                 STA   cmdbuffl+1
0647 5367 B0 03                 BCS   H536C
0648 5369 82 3F FF              BRL   H52AB
0649 536C A9 22        H536C    LDA   #$22
0650 536E 80 8E                 BRA   H52FE
0651 5370 A6 5D        H5370    LDX   basesave
0652 5372 86 43                 STX   cmdbuffl+1
0653 5374 18                    CLC   
0654 5375 60                    RTS   
